function varargout = TDA(varargin)
%TDA MATLAB code file for TDA.fig
%      TDA, by itself, creates a new TDA or raises the existing
%      singleton*.
%
%      H = TDA returns the handle to a new TDA or the handle to
%      the existing singleton*.
%
%      TDA('Property','Value',...) creates a new TDA using the
%      given property value pairs. Unrecognized properties are passed via
%      varargin to TDA_OpeningFcn.  This calling syntax produces a
%      warning when there is an existing singleton*.
%
%      TDA('CALLBACK') and TDA('CALLBACK',hObject,...) call the
%      local function named CALLBACK in TDA.M with the given input
%      arguments.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help TDA

% Last Modified by GUIDE v2.5 07-Mar-2024 15:33:59

% Begin initialization code - DO NOT EDIT
%-----------------------------------------------------------
%   Written by SUN Jia-Wei 200413.
%   Mail to Authors: jiaweisun0512@163.com
%
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @TDA_OpeningFcn, ...
                   'gui_OutputFcn',  @TDA_OutputFcn, ...
                   'gui_LayoutFcn',  [], ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
   gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before TDA is made visible.
function TDA_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   unrecognized PropertyName/PropertyValue pairs from the

handles.output = hObject;
guidata(hObject, handles);
ReMoveAllPanel(hObject, eventdata, handles);
% Settogbutton2off(handles)
set(handles.rbtn_NorEa,'Visible','off');
set(handles.rbtn_NorEu,'Visible','off');
set(handles.panel_Blank,'Visible','on');
% UIWAIT makes TDA wait for user response (see UIRESUME)
% uiwait(handles.figure1);
handles = InitAllParameter(handles);
guidata(hObject, handles);

% --- Outputs from this function are returned to the command line.
function varargout = TDA_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output; 


%WorkPath and TR and Sub


function psbtn_WorkDir_Callback(hObject, eventdata, handles)
WorkPath = uigetdir(pwd);
if exist(num2str(WorkPath),'dir')
    set(handles.edit_WorkDir,'string',WorkPath);
    cd(WorkPath);
    handles.WorkPath = WorkPath;
else
    set(handles.edit_WorkDir,'string',pwd);
    handles.WorkPath = pwd;  
end
guidata(hObject, handles);

function edit_TR_Callback(hObject, eventdata, handles)
handles.TR = get(hObject,'String');
guidata(hObject, handles);

function edit_TR_CreateFcn(hObject, eventdata, handles)
set(hObject,'String','2');
handles.TR = get(hObject,'String');
guidata(hObject, handles);

function cebx_EPIName_Callback(hObject, eventdata, handles)
Object = handles.edit_EPIName;
if (get(hObject,'Value')==get(Object,'Max'))
    set(Object,'Enable','on')
elseif (get(hObject,'Value')==get(Object,'Min'))
    set(Object,'Enable','off')
end

function cebx_T1Name_Callback(hObject, eventdata, handles)
Object = handles.edit_T1Name;
if (get(hObject,'Value')==get(Object,'Max'))
    set(Object,'Enable','on')
elseif (get(hObject,'Value')==get(Object,'Min'))
    set(Object,'Enable','off')
end

function edit_EPIName_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
if ~isempty(get(hObject,'String'))
    set(handles.panel_Blank,'Visible','off');
    set(handles.panel_SubList,'Visible','on');
end
ListObject = handles.list_SubList;
FunName = get(hObject,'String');
WorkPath = handles.WorkPath;
FunPath = [WorkPath filesep FunName];
if exist(FunPath,'dir')
    Sub = dir(FunPath);
    if length(Sub) == 2
        set(ListObject,'String','EPIPath Have none SubFolder');  
        handles.EPIPath = '';
    else
        SubName = dir_NameList(FunPath);
        set(ListObject,'String',SubName); 
        handles.EPIPath = FunPath;
        handles.EPISub = SubName;
    end    
else
    set(ListObject,'String','Don''t have this EPIPath'); 
    handles.EPIPath = '';
end
guidata(hObject, handles);

function edit_T1Name_Callback(hObject, eventdata, handles)

ReMoveAllPanel(hObject, eventdata, handles);
if ~isempty(get(hObject,'String'))
    set(handles.panel_Blank,'Visible','off');
    set(handles.panel_SubList,'Visible','on');
end
ListObject = handles.list_SubList;
T1Name = get(hObject,'String');
WorkPath = handles.WorkPath;
T1Path = [WorkPath filesep T1Name];
if exist(T1Path,'dir')
    Sub = dir(T1Path);
    if length(Sub) == 2
        set(ListObject,'String','T1Path Have none SubFolder');  
        handles.T1Path = '';
    else
        SubName = dir_NameList(T1Path);
        set(ListObject,'String',SubName); 
        handles.T1Path = T1Path;
        handles.T1Sub = SubName;
    end    
else
    set(ListObject,'String','Don''t have this T1Path'); 
    handles.T1Path = '';
end
guidata(hObject, handles);

function edit_WorkDir_Callback(hObject, eventdata, handles)
WorkPath = get(hObject,'String');
if exist(num2str(WorkPath),'dir')
    handles.WorkPath = WorkPath;
else
    error([WorkPath ' don''t exist']);
end
guidata(hObject, handles);

function edit_WorkDir_CreateFcn(hObject, eventdata, handles)
set(hObject,'String',pwd);
handles.WorkPath = pwd;
guidata(hObject, handles);

function list_SubList_Callback(hObject, eventdata, handles)
function list_SubList_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
function edit_EPIName_CreateFcn(hObject, eventdata, handles)
set(hObject,'Enable','off')
function edit_T1Name_CreateFcn(hObject, eventdata, handles)
set(hObject,'Enable','off')

function edit_EPIName_ButtonDownFcn(hObject, eventdata, handles)
function edit_T1Name_ButtonDownFcn(hObject, eventdata, handles)
function edit_TR_ButtonDownFcn(hObject, eventdata, handles)


% PreCov
function cebx_Cov_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_PreCov;
if (get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
    handles.Cov.IsCov = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    set(Object,'Visible','off');
    set(handles.panel_Blank,'Visible','on');
    handles.Cov.IsCov = 0;
end
guidata(hObject, handles);

function cebx_CovOther_Callback(hObject, eventdata, handles)
if (get(hObject,'Value')==get(hObject,'Max'))
    if isempty(get(handles.list_FCList,'String'))
        handles.Cov.CovOtherROI = rp_ROIList_gui({});
        set(handles.list_CovOtherList,'String',handles.Cov.CovOtherROI);
    else
        handles.Cov.CovOtherROI = rp_ROIList_gui(get(handles.list_CovOtherList,'String'));
        set(handles.list_CovOtherList,'String',handles.Cov.CovOtherROI);
    end
elseif (get(hObject,'Value')==get(hObject,'Min'))
    handles.Cov.CovOtherROI = {''};
    set(handles.list_CovOtherList,'String','');
end
guidata(hObject, handles);

function cebx_CovCSF_Callback(hObject, eventdata, handles)
if (get(hObject,'Value')==get(hObject,'Max'))
    handles.Cov.IsCovCSF = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    handles.Cov.IsCovCSF = 0;
end
guidata(hObject, handles);

function cebx_CovFriston_Callback(hObject, eventdata, handles)
if (get(hObject,'Value')==get(hObject,'Max'))
    handles.Cov.IsCovFriston24 = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    handles.Cov.IsCovFriston24 = 0;
end
guidata(hObject, handles);

function cebx_CovGlobal_Callback(hObject, eventdata, handles)
if (get(hObject,'Value')==get(hObject,'Max'))
    handles.Cov.IsCovGlobal = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    handles.Cov.IsCovGlobal = 0;
end
guidata(hObject, handles);

function cebx_CovWM_Callback(hObject, eventdata, handles)
if (get(hObject,'Value')==get(hObject,'Max'))
    handles.Cov.IsCovWM = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    handles.Cov.IsCovWM = 0;
end
guidata(hObject, handles);

function cebx_CovAddMean_Callback(hObject, eventdata, handles)
if (get(hObject,'Value')==get(hObject,'Max'))
    handles.Cov.IsAddMeanBack = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    handles.Cov.IsAddMeanBack = 0;
end
guidata(hObject, handles);

function edit_CovDetrend_Callback(hObject, eventdata, handles)
if strcmp(get(hObject,'String'),'1')
    handles.Cov.IsCovDetrend = 1;
else
    handles.Cov.IsCovDetrend = 0;
end
guidata(hObject, handles);

function edit_CovDetrend_CreateFcn(hObject, eventdata, handles)
set(hObject,'String','1');
handles.Cov.IsCovDetrend = 1;
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
guidata(hObject, handles);

function list_CovOtherList_Callback(hObject, eventdata, handles)
    
function list_CovOtherList_CreateFcn(hObject, eventdata, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%Pre Smooth
function cebx_Smooth_Callback(hObject, eventdata, handles)

ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_PreSmooth;
if (get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
    handles.Smooth.IsSmooth = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    set(Object,'Visible','off');
    set(handles.panel_Blank,'Visible','on');
    handles.Smooth.IsSmooth = 0;
end
guidata(hObject, handles);

function edit_PreFWHM_Callback(hObject, eventdata, handles)
handles.Smooth.FWHM = get(hObject,'String');
guidata(hObject, handles);

function edit_PreFWHM_CreateFcn(hObject, eventdata, handles)
set(hObject,'String','[6 6 6]');
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
handles.Smooth.FWHM = get(hObject,'String');
guidata(hObject, handles);


%Pre RemoveTime
function cebx_RemoveTime_Callback(hObject, eventdata, handles)

ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_PreRemoveTime;
if (get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
    handles.RemoveTime.IsRemoveTime = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    set(Object,'Visible','off');
    set(handles.panel_Blank,'Visible','on');
    handles.RemoveTime.IsRemoveTime = 0;
end
guidata(hObject, handles);

function edit_RemoveTime_Callback(hObject, eventdata, handles)
handles.RemoveTime.Time = get(hObject,'String');
guidata(hObject, handles);

function edit_RemoveTime_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String','10');
handles.RemoveTime.Time = get(hObject,'String');
guidata(hObject, handles);


%Pre D2N
function cebx_D2N_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_PreD2N;
if (get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
    handles.D2N.IsD2N = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    set(Object,'Visible','off');
    set(handles.panel_Blank,'Visible','on');
    handles.D2N.IsD2N = 0;
end
guidata(hObject, handles);

function cebx_EPI_Callback(hObject, eventdata, handles)
if get(hObject,'Value') == get(hObject,'Max');
    handles.D2N.EPI = 1;
elseif get(hObject,'Value') == get(hObject,'Min');
    handles.D2N.EPI = 0;
end
guidata(hObject, handles);

function cebx_T1_Callback(hObject, eventdata, handles)
if get(hObject,'Value') == get(hObject,'Max');
    handles.D2N.T1 = 1;
elseif get(hObject,'Value') == get(hObject,'Min');
    handles.D2N.T1 = 0;
end
guidata(hObject, handles);

%Pre Slice
function cebx_Slice_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_PreSlice;
if (get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
    handles.Slice.IsSlice = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    set(Object,'Visible','off');
    set(handles.panel_Blank,'Visible','on');
    handles.Slice.IsSlice = 0;
end
guidata(hObject, handles);

function edit_SliceNumber_Callback(hObject, eventdata, handles)
handles.Slice.SliceNumber = get(hObject,'String');
guidata(hObject, handles);

function edit_SliceNumber_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String','33');
handles.Slice.SliceNumber = get(hObject,'String');
guidata(hObject, handles);

function edit_SliceOrder_Callback(hObject, eventdata, handles)
OrderStr = num2str(str2num(get(hObject,'String')));
set(hObject,'String',OrderStr);
handles.Slice.SliceOrder = OrderStr;
guidata(hObject, handles);

function edit_SliceOrder_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String',num2str([1:2:33 2:2:32]));
handles.Slice.SliceOrder = get(hObject,'String');
guidata(hObject, handles);

function edit_SliceRefer_Callback(hObject, eventdata, handles)
handles.Slice.SliceRefer = get(hObject,'String');
guidata(hObject, handles);

function edit_SliceRefer_CreateFcn(hObject, eventdata, handles)
set(hObject,'String','33');
handles.Slice.SliceRefer = get(hObject,'String');
guidata(hObject, handles);

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


%Pre Realign
function cebx_Realign_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_PreRealign;
if (get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
    handles.Realign.IsRealign = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    set(Object,'Visible','off');
    set(handles.panel_Blank,'Visible','on');
    handles.Realign.IsRealign = 0;
end
guidata(hObject, handles);



%Pre Detrend
function cebx_Detrend_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_PreDetrend;
if (get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
    handles.Detrend.IsDetrend = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    set(Object,'Visible','off');
    set(handles.panel_Blank,'Visible','on');
    handles.Detrend.IsDetrend = 0;
end
guidata(hObject, handles);


%Pre Normal
function cebx_Normal_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_PreNormal;
if (get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
    handles.Normal.IsNormal = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    set(Object,'Visible','off');
    set(handles.panel_Blank,'Visible','on');
    handles.Normal.IsNormal = 0;
end
guidata(hObject, handles);

function edit_Bbox_Callback(hObject, eventdata, handles)
handles.Normal.Bbox = get(hObject,'String');
guidata(hObject, handles);

function edit_Bbox_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String','[-90,-126,-72;90,90,108]');
handles.Normal.Bbox = get(hObject,'String');
guidata(hObject, handles);

function edit_VoxelSize_Callback(hObject, eventdata, handles)
handles.Normal.VoxelSize = get(hObject,'String');
guidata(hObject, handles);

function edit_VoxelSize_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String','[3 3 3]');
handles.Normal.VoxelSize = get(hObject,'String');
guidata(hObject, handles);


function rbtn_NorEPI_Callback(hObject, eventdata, handles)
set(handles.rbtn_NorEPI,'Value',1);
set(handles.rbtn_NorT1New,'Value',0);
set(handles.rbtn_NorT1Unifi,'Value',0);
set(handles.rbtn_NorT1Dartel,'Value',0);
set(handles.rbtn_NorEa,'Visible','off');
set(handles.rbtn_NorEu,'Visible','off');
handles.Normal.Method = 'EPI';
guidata(hObject, handles);

function rbtn_NorEPI_CreateFcn(hObject, eventdata, handles)
set(hObject,'Value',1);
handles.Normal.Method = 'EPI';
guidata(hObject, handles);

function rbtn_NorT1New_Callback(hObject, eventdata, handles)
set(handles.rbtn_NorEPI,'Value',0);
set(handles.rbtn_NorT1New,'Value',1);
set(handles.rbtn_NorT1Unifi,'Value',0);
set(handles.rbtn_NorT1Dartel,'Value',0);
set(handles.rbtn_NorEa,'Visible','on');
set(handles.rbtn_NorEu,'Visible','on');
handles.Normal.Method = 'T1New';
guidata(hObject, handles);

function rbtn_NorT1Unifi_Callback(hObject, eventdata, handles)
set(handles.rbtn_NorEPI,'Value',0);
set(handles.rbtn_NorT1New,'Value',0);
set(handles.rbtn_NorT1Unifi,'Value',1);
set(handles.rbtn_NorT1Dartel,'Value',0);
set(handles.rbtn_NorEa,'Visible','on');
set(handles.rbtn_NorEu,'Visible','on');
handles.Normal.Method = 'T1Unified';
guidata(hObject, handles);

function rbtn_NorT1Dartel_Callback(hObject, eventdata, handles)
set(handles.rbtn_NorEPI,'Value',0);
set(handles.rbtn_NorT1New,'Value',0);
set(handles.rbtn_NorT1Unifi,'Value',0);
set(handles.rbtn_NorT1Dartel,'Value',1);
set(handles.rbtn_NorEa,'Visible','on');
set(handles.rbtn_NorEu,'Visible','on');
handles.Normal.Method = 'T1Dartel';
guidata(hObject, handles);

function rbtn_NorEa_Callback(hObject, eventdata, handles)
set(handles.rbtn_NorEa,'Value',1);
set(handles.rbtn_NorEu,'Value',0);
handles.Normal.People = 'Ea';
guidata(hObject, handles);

function rbtn_NorEu_Callback(hObject, eventdata, handles)
set(handles.rbtn_NorEa,'Value',0);
set(handles.rbtn_NorEu,'Value',1);
handles.Normal.People = 'Eu';
guidata(hObject, handles);

function rbtn_NorEu_CreateFcn(hObject, eventdata, handles)
set(hObject,'Value',1);
handles.Normal.People = 'Eu';
guidata(hObject, handles);


%Pre Filter
function cebx_Filter_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_PreFilter;
if (get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
    handles.Filter.IsFilter = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    set(Object,'Visible','off');
    set(handles.panel_Blank,'Visible','on');
    handles.Filter.IsFilter = 0;
end
guidata(hObject, handles);

function edit_FilterLowcut_Callback(hObject, eventdata, handles)
handles.Filter.LowCut_HighPass = get(hObject,'String');
guidata(hObject, handles);

function edit_FilterHighcut_Callback(hObject, eventdata, handles)
handles.Filter.LowPass_HighCut = get(hObject,'String');
guidata(hObject, handles);

function edit_FilterLowcut_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String','0.01');
handles.Filter.LowCut_HighPass = get(hObject,'String');
guidata(hObject, handles);

function edit_FilterHighcut_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String','0.08');
handles.Filter.LowPass_HighCut = get(hObject,'String');
guidata(hObject, handles);


% %Pre Reorient
% function cebx_Reorient_Callback(hObject, eventdata, handles)
% ReMoveAllPanel(hObject, eventdata, handles);
% Object = handles.panel_PreReorient;
% if (get(hObject,'Value')==get(hObject,'Max'))
%     set(Object,'Visible','on');
%     handles.Reorient.IsReorient = 1;
% elseif (get(hObject,'Value')==get(hObject,'Min'))
%     set(Object,'Visible','off');
%     set(handles.panel_Blank,'Visible','on');
%     handles.Reorient.IsReorient = 0;
% end
% guidata(hObject, handles);
% 
% function rbtn_BforCoreg_Callback(hObject, eventdata, handles)
% set(handles.rbtn_BforCoreg,'Value',1);
% set(handles.rbtn_AfterCoreg,'Value',0);
% handles.Reorient.Time = 'BeforeCoreg';
% guidata(hObject, handles);
% 
% function rbtn_AfterCoreg_Callback(hObject, eventdata, handles)
% set(handles.rbtn_BforCoreg,'Value',0);
% set(handles.rbtn_AfterCoreg,'Value',1);
% handles.Reorient.Time = 'AfterCoreg';
% guidata(hObject, handles);

%Pre totbn
function tobtn_D2N_Callback(hObject, eventdata, handles)

ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_PreD2N;
if(get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
end

function tobtn_RemoveTime_Callback(hObject, eventdata, handles)

ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_PreRemoveTime;
if(get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
end

function tobtn_Realign_Callback(hObject, eventdata, handles)

ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_PreRealign;
if(get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
end

function tobtn_Nomal_Callback(hObject, eventdata, handles)

ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_PreNormal;
if(get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
end

function tobtn_Smooth_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_PreSmooth;
if(get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
end

function tobtn_Detrend_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_PreDetrend;
if(get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
end

function tobtn_Filter_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_PreFilter;
if(get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
end

function tobtn_Cov_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_PreCov;
if(get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
end

function tobtn_Slice_Callback(hObject, eventdata, handles)

ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_PreSlice;
if(get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
end

% function tobtn_Reorient_Callback(hObject, eventdata, handles)
% ReMoveAllPanel(hObject, eventdata, handles);
% Object = handles.panel_PreReorient;
% if(get(hObject,'Value')==get(hObject,'Max'))
%     set(Object,'Visible','on');
% end




%Dynamic Paremeter
function tobtn_DyPara_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_DyPara;
if(get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
end

function edit_WinSize_Callback(hObject, eventdata, handles)
handles.DyPara.WinSize = get(hObject,'String');
guidata(hObject, handles);

function edit_WinStep_Callback(hObject, eventdata, handles)
handles.DyPara.WinStep = get(hObject,'String');
guidata(hObject, handles);

function edit_WinSize_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String','30');
handles.DyPara.WinSize = get(hObject,'String');
guidata(hObject, handles);

function edit_WinStep_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String','1');
handles.DyPara.WinStep = get(hObject,'String');
guidata(hObject, handles);

function pomenu_WinType_Callback(hObject, eventdata, handles)
Window = {'hamming','rectwin','hann'};
handles.DyPara.WinType = get(hObject,'Value');
handles.DyPara.WinType = Window{handles.DyPara.WinType};
guidata(hObject, handles);

function pomenu_WinType_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
Window = {'hamming','rectwin','hann'};
set(hObject,'String',Window);
handles.DyPara.WinType = get(hObject,'Value');
handles.DyPara.WinType = Window{handles.DyPara.WinType};
guidata(hObject, handles);

function rbtn_DyDefault_Callback(hObject, eventdata, handles)
set(handles.rbtn_DyDefault,'Value',1);
set(handles.rbtn_DyNoMask,'Value',0);
set(handles.rbtn_DyUser,'Value',0);
set(handles.edit_DyUser,'Enable','off')
handles.DyMask = 'Default';
guidata(hObject, handles);

function rbtn_DyDefault_CreateFcn(hObject, eventdata, handles)
set(hObject,'Value',1);
handles.DyMask = 'Default';
guidata(hObject, handles);

function rbtn_DyNoMask_Callback(hObject, eventdata, handles)
set(handles.rbtn_DyDefault,'Value',0);
set(handles.rbtn_DyNoMask,'Value',1);
set(handles.rbtn_DyUser,'Value',0);
handles.DyMask = 'No';
set(handles.edit_DyUser,'Enable','off')
guidata(hObject, handles);

function rbtn_DyUser_Callback(hObject, eventdata, handles)
set(handles.rbtn_DyDefault,'Value',0);
set(handles.rbtn_DyNoMask,'Value',0);
set(handles.rbtn_DyUser,'Value',1);
Object = handles.edit_DyUser;
if (get(hObject,'Value')==get(Object,'Max'))
    set(Object,'Enable','on')
end
[FileName,PathName] = uigetfile({'*.img;*.nii;*.nii.gz','Brain Image Files (*.img;*.nii;*.nii.gz)';'*.*', 'All Files (*.*)';}, 'Pick a mask');
handles.DyMask = [PathName FileName];
set(handles.edit_DyUser,'String',handles.DyMask)
guidata(hObject, handles);

function edit_DyUser_Callback(hObject, eventdata, handles)
MaskPath = get(hObject,'String');
[mpath,mname,msuffix] = fileparts(MaskPath);
if ~exist(MaskPath,'file')
    error('Mask isn''t exist');
else
    handles.DyMask = MaskPath;
    guidata(hObject, handles);
end

function edit_DyUser_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'Enable','off')

% --- Executes on button press in cebx_DyDetrend.
function cebx_DyDetrend_Callback(hObject, eventdata, handles)
if (get(hObject,'Value')==get(hObject,'Max'))
    handles.DyPara.Detrend = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    handles.DyPara.Detrend = 0;
end
guidata(hObject, handles);


% Dynamic ALFF
function cebx_ALFF_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_DyALFF;
if (get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
    handles.DyALFF.IsALFF = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    set(Object,'Visible','off');
    set(handles.panel_Blank,'Visible','on');
    handles.DyALFF.IsALFF = 0;
end
guidata(hObject, handles);

function edit_ALFFLowcut_Callback(hObject, eventdata, handles)
handles.DyALFF.LowCut_HighPass = get(hObject,'String');
guidata(hObject, handles);

function edit_ALFFHighcut_Callback(hObject, eventdata, handles)
handles.DyALFF.LowPass_HighCut = get(hObject,'String');
guidata(hObject, handles);

function edit_ALFFLowcut_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String','0.01');
handles.DyALFF.LowCut_HighPass = get(hObject,'String');
guidata(hObject, handles);

function edit_ALFFHighcut_CreateFcn(hObject, eventdata, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String','0.08');
handles.DyALFF.LowPass_HighCut = get(hObject,'String');
guidata(hObject, handles);


% Dynamic fALFF
function cebx_fALFF_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_DyfALFF;
if (get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
    handles.DyfALFF.IsfALFF = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    set(Object,'Visible','off');
    set(handles.panel_Blank,'Visible','on');
    handles.DyfALFF.IsfALFF = 0;
end
guidata(hObject, handles);

function edit_fALFFLowcut_Callback(hObject, eventdata, handles)
handles.DyfALFF.LowCut_HighPass = get(hObject,'String');
guidata(hObject, handles);

function edit_fALFFHighcut_Callback(hObject, eventdata, handles)
handles.DyfALFF.LowPass_HighCut = get(hObject,'String');
guidata(hObject, handles);

function edit_fALFFLowcut_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String','0.01');
handles.DyfALFF.LowCut_HighPass = get(hObject,'String');
guidata(hObject, handles);

function edit_fALFFHighcut_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String','0.08');
handles.DyfALFF.LowPass_HighCut = get(hObject,'String');
guidata(hObject, handles);



% Dynamic FC
function cebx_FC_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_DyFC;
if (get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
    handles.DyFC.IsFC = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    set(Object,'Visible','off');
    set(handles.panel_Blank,'Visible','on');
    handles.DyFC.IsFC = 0;
end
guidata(hObject, handles);

% --- Executes on button press in cebx_PerAF.
function cebx_PerAF_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
if (get(hObject,'Value')==get(hObject,'Max'))
    set(handles.panel_Blank,'Visible','on');
    handles.DyPerAF.IsPerAF = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    set(handles.panel_Blank,'Visible','on');
    handles.DyPerAF.IsPerAF = 0;
end
guidata(hObject, handles);


function pstbn_FCROI_Callback(hObject, eventdata, handles)
if (get(hObject,'Value')==get(hObject,'Max'))
    if isempty(get(handles.list_FCList,'String'))
        FCROIDef=rp_ROIList_gui({});
        set(handles.list_FCList,'String',FCROIDef);
    else
        FCROIDef=rp_ROIList_gui(get(handles.list_FCList,'String'));
        set(handles.list_FCList,'String',FCROIDef);
    end
end
guidata(hObject, handles);

function cebx_FCMultiple_Callback(hObject, eventdata, handles)
if (get(hObject,'Value')==get(hObject,'Max'))
    handles.DyFC.IsMultiple = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    handles.DyFC.IsMultiple = 0;
end
guidata(hObject, handles);

function list_FCList_Callback(hObject, eventdata, handles)

function list_FCList_CreateFcn(hObject, eventdata, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function FCROIDef = GetFCROI(handles)
if ~isempty(handles.DyFC.FCROIDef)
    for i = 1 : length(handles.DyFC.FCROIDef)
        if SphereROI('IsBallStr', handles.DyFC.FCROIDef{i})
            FCROIDef{i}=SphereROI('BallStr2BallArray', handles.DyFC.FCROIDef{i}); 
        else
            FCROIDef{i} = handles.DyFC.FCROIDef{i};
        end
    end
else
    error('FC ROI Is empty')
end


% Dynamic DC

function cebx_DC_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_DyDC;
if (get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
    handles.DyDC.IsDC = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    set(Object,'Visible','off');
    set(handles.panel_Blank,'Visible','on');
    handles.DyDC.IsDC = 0;
end
guidata(hObject, handles);

function edit_DCr_Callback(hObject, eventdata, handles)
handles.DyDC.rValue = get(hObject,'String');
guidata(hObject, handles);

function edit_DCr_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String','0.25');
handles.DyDC.rValue = get(hObject,'String');
guidata(hObject, handles);


% Dynamic ReHo
function cebx_ReHo_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_DyReHo;
if (get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
    handles.DyReHo.IsReHo = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    set(Object,'Visible','off');
    set(handles.panel_Blank,'Visible','on');
    handles.DyReHo.IsReHo = 0;
end
guidata(hObject, handles);

function rbtn_ReHo7_Callback(hObject, eventdata, handles)
set(handles.rbtn_ReHo7,'Value',1);
set(handles.rbtn_ReHo19,'Value',0);
set(handles.rbtn_ReHo27,'Value',0);
handles.DyReHo.Cluster = 7;
guidata(hObject, handles);

function rbtn_ReHo19_Callback(hObject, eventdata, handles)
set(handles.rbtn_ReHo7,'Value',0);
set(handles.rbtn_ReHo19,'Value',1);
set(handles.rbtn_ReHo27,'Value',0);
hanles.DyReHo.Cluster = 19;
guidata(hObject, handles);

function rbtn_ReHo27_Callback(hObject, eventdata, handles)
set(handles.rbtn_ReHo7,'Value',0);
set(handles.rbtn_ReHo19,'Value',0);
set(handles.rbtn_ReHo27,'Value',1);
handles.DyReHo.Cluster = 27;
guidata(hObject, handles);

function rbtn_ReHo27_CreateFcn(hObject, eventdata, handles)
set(hObject,'Value',1);
handles.DyReHo.Cluster = 27;
guidata(hObject, handles);

%Dynamic GSCorr
function cebx_GSCorr_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_DyGSCorr;
if (get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
    handles.DyGSCorr.IsGSCorr = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    set(Object,'Visible','off');
    set(handles.panel_Blank,'Visible','on');
    handles.DyGSCorr.IsGSCorr = 0;
end
guidata(hObject, handles);

%Dynamic VMHC
function cebx_VMHC_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_DyVMHC;
if (get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
    handles.DyVMHC.IsVMHC = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    set(Object,'Visible','off');
    set(handles.panel_Blank,'Visible','on');
    handles.DyVMHC.IsVMHC = 0;
end
guidata(hObject, handles);



%Dynamic ConcorPar
function cebx_DyConcor_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_DyConcor;
if (get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
    handles.DyConcor.IsConcor = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    set(Object,'Visible','off');
    set(handles.panel_Blank,'Visible','on');
    handles.DyConcor.IsConcor = 0;
end
guidata(hObject, handles);

function cebx_ConVoxel_Callback(hObject, eventdata, handles)
if (get(hObject,'Value')==get(hObject,'Max'))
    handles.DyConcor.IsVoxelWise = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    handles.DyConcor.IsVoxelWise = 0;
end
guidata(hObject, handles);

function cebx_ConVolume_Callback(hObject, eventdata, handles)
if (get(hObject,'Value')==get(hObject,'Max'))
    handles.DyConcor.IsVolumeWise = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    handles.DyConcor.IsVolumeWise = 0;
end
guidata(hObject, handles);

function cebx_ConSmooth_Callback(hObject, eventdata, handles)
if (get(hObject,'Value')==get(hObject,'Max'))
    handles.DyConcor.IsSmooth = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    handles.DyConcor.IsSmooth = 0;
end
guidata(hObject, handles);

function edit_ConFWHM_Callback(hObject, eventdata, handles)
handles.DyConcor.FWHM = get(hObject,'String');
guidata(hObject, handles);

function edit_ConFWHM_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String','[6 6 6]');
handles.DyConcor.FWHM = get(hObject,'String');
guidata(hObject, handles);

function cebx_ConALFF_Callback(hObject, eventdata, handles)
if (get(hObject,'Value')==get(hObject,'Max'))
    handles.DyConcor.IsALFF = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    handles.DyConcor.IsALFF = 0;
end
guidata(hObject, handles);

function cebx_ConfALFF_Callback(hObject, eventdata, handles)
if (get(hObject,'Value')==get(hObject,'Max'))
    handles.DyConcor.IsfALFF = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    handles.DyConcor.IsfALFF = 0;
end
guidata(hObject, handles);

function cebx_ConReHo_Callback(hObject, eventdata, handles)
if (get(hObject,'Value')==get(hObject,'Max'))
    handles.DyConcor.IsReHo = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    handles.DyConcor.IsReHo = 0;
end
guidata(hObject, handles);

function cebx_ConDC_Callback(hObject, eventdata, handles)
if (get(hObject,'Value')==get(hObject,'Max'))
    handles.DyConcor.IsDC = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    handles.DyConcor.IsDC = 0;
end
guidata(hObject, handles);

function cebx_ConGSCorr_Callback(hObject, eventdata, handles)
if (get(hObject,'Value')==get(hObject,'Max'))
    handles.DyConcor.IsGSCorr = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    handles.DyConcor.IsGSCorr = 0;
end
guidata(hObject, handles);

function cebx_ConVMHC_Callback(hObject, eventdata, handles)
if (get(hObject,'Value')==get(hObject,'Max'))
    handles.DyConcor.IsVMHC = 1;
elseif (get(hObject,'Value')==get(hObject,'Min'))
    handles.DyConcor.IsVMHC = 0;
end
guidata(hObject, handles);





function tobtn_ALFF_Callback(hObject, eventdata, handles)
% hObject    handle to tobtn_ALFF (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_DyALFF;
if(get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
end

function tobtn_fALFF_Callback(hObject, eventdata, handles)
% hObject    handle to tobtn_fALFF (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_DyfALFF;
if(get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
end

function tobtn_ReHo_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_DyReHo;
if(get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
end

function tobtn_DC_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_DyDC;
if(get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
end

% --- Executes on button press in tobtn_PerAF.
function tobtn_PerAF_Callback(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles);
set(handles.panel_Blank,'Visible','on');

function tobtn_GSCorr_Callback(hObject, eventdata, handles)
% hObject    handle to tobtn_GSCorr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_DyGSCorr;
if(get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
end


% --- Executes on button press in rbtn_GSCorrDefault.
function rbtn_GSCorrDefault_Callback(hObject, eventdata, handles)
set(handles.rbtn_GSCorrDefault,'Value',1)
set(handles.rbtn_GSCorrUser,'Value',0);
handles.DyGSCorr.Mask = 'Default';
set(handles.edit_GSCorrUser,'Enable','off')
guidata(hObject, handles);

function rbtn_GSCorrDefault_CreateFcn(hObject, eventdata, handles)
set(hObject,'Value',1)
handles.DyGSCorr.Mask = 'Default';
guidata(hObject, handles);

% --- Executes on button press in rbtn_GSCorrUser.
function rbtn_GSCorrUser_Callback(hObject, eventdata, handles)
set(handles.rbtn_GSCorrDefault,'Value',0)
set(handles.rbtn_GSCorrUser,'Value',1);
MaskPath = get(hObject,'String');
[mpath,mname,msuffix] = fileparts(MaskPath);
[FileName,PathName] = uigetfile({'*.img;*.nii;*.nii.gz','Brain Image Files (*.img;*.nii;*.nii.gz)';'*.*', 'All Files (*.*)';}, 'Pick a mask');
handles.DyGSCorr.Mask = [PathName FileName];
set(handles.edit_GSCorrUser,'Enable','on')
set(handles.edit_GSCorrUser,'String',handles.DyGSCorr.Mask)
guidata(hObject, handles);


function edit_GSCorrUser_Callback(hObject, eventdata, handles)



% --- Executes during object creation, after setting all properties.
function edit_GSCorrUser_CreateFcn(hObject, eventdata, handles)

set(hObject,'Enable','off')
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
function tobtn_FC_Callback(hObject, eventdata, handles)
% hObject    handle to tobtn_FC (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_DyFC;
if(get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
end

function tobtn_VMHC_Callback(hObject, eventdata, handles)
% hObject    handle to tobtn_VMHC (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_DyVMHC;
if(get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
end

function tobtn_DyConcor_Callback(hObject, eventdata, handles)
% hObject    handle to tobtn_DyConcor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
ReMoveAllPanel(hObject, eventdata, handles);
Object = handles.panel_DyConcor;
if(get(hObject,'Value')==get(hObject,'Max'))
    set(Object,'Visible','on');
end


function ReMoveAllPanel(hObject, eventdata, handles)
set(handles.panel_Blank,'Visible','off');
set(handles.panel_SubList,'Visible','off');
set(handles.panel_PreD2N,'Visible','off');
set(handles.panel_PreRemoveTime,'Visible','off');
set(handles.panel_PreSlice,'Visible','off');
set(handles.panel_PreRealign,'Visible','off');
set(handles.panel_PreNormal,'Visible','off');
set(handles.panel_PreSmooth,'Visible','off');
set(handles.panel_PreDetrend,'Visible','off');
set(handles.panel_PreCov,'Visible','off');
% set(handles.panel_PreReorient,'Visible','off');
set(handles.panel_PreFilter,'Visible','off');
set(handles.panel_DyPara,'Visible','off');
set(handles.panel_DyReHo,'Visible','off');
% set(handles.panel_DyConcor,'Visible','off');
set(handles.panel_DyALFF,'Visible','off');
set(handles.panel_DyfALFF,'Visible','off');
set(handles.panel_DyDC,'Visible','off');
% set(handles.panel_DyGSCorr,'Visible','off');
% set(handles.panel_DyVMHC,'Visible','off');
set(handles.panel_DyDC,'Visible','off');
set(handles.panel_DyFC,'Visible','off');

% function Settogbutton2off(handles)
% set(handles.tobtn_ALFF,'Value','off')
% set(handles.tobtn_fALFF,'Value','off')
% set(handles.tobtn_ReHo,'Value','off')
% set(handles.tobtn_DC,'Value','off')
% set(handles.tobtn_GSCorr,'Value','off')
% set(handles.tobtn_FC,'Value','off')
% set(handles.tobtn_VMHC,'Value','off')
% set(handles.tobtn_DyConcor,'Value','off')
% set(handles.tobtn_Dypara,'Value','off')
% set(handles.tobtn_D2N,'Value','off')
% set(handles.tobtn_RemoveTime,'Value','off')
% set(handles.tobtn_Realign,'Value','off')
% set(handles.tobtn_Nomal,'Value','off')
% set(handles.tobtn_Smooth,'Value','off')
% set(handles.tobtn_Detrend,'Value','off')
% set(handles.tobtn_Filter,'Value','off')
% set(handles.tobtn_Cov,'Value','off')
% set(handles.tobtn_Slice,'Value','off')
% set(handles.tobtn_Reorient,'Value','off')

function handles = InitAllParameter(handles)
% handles.WorkPath = '';
% handles.TR = '';
handles.EPIPath = '';
handles.EPISub = '';
handles.T1Path = '';
handles.T1Sub = '';

handles.D2N.IsD2N = 0;
handles.D2N.EPI = 0;
handles.D2N.T1 = 0;
handles.RemoveTime.IsRemoveTime = 0;
% handles.RemoveTime.Time = '';
handles.Slice.IsSlice = 0;
% handles.Slice.SliceNumber = '';
% handles.Slice.SliceOrder = '';
% handles.Slice.SliceRefer = '';
handles.Realign.IsRealign = 0;
handles.Normal.IsNormal = 0;
% handles.Normal.Bbox = '';
% handles.Normal.VoxelSize = '';
% handles.Normal.Method = '';
% handles.Normal.People = '';
handles.Smooth.IsSmooth = 0;
% handles.Smooth.FWHM = '';
handles.Detrend.IsDetrend = 0;
handles.Cov.IsCov = 0;
% handles.Cov.IsCovDetrend = 0;
handles.Cov.IsCovFriston24 = 0;
handles.Cov.IsCovGlobal = 0;
handles.Cov.IsCovWM = 0;
handles.Cov.IsCovCSF = 0;
handles.Cov.IsAddMeanBack = 0;
handles.Cov.CovOtherROI = {''};
handles.Cov.IsCovOther = 0;
handles.Filter.IsFilter = 0;
% handles.Filter.LowCut_HighPass = '';
% handles.Filter.LowPass_HighCut = '';
% handles.Reorient.IsReorient = 0;
% handles.Reorient.Time = '';

% handles.DyPara.WinSize = '';
% handles.DyPara.WinStep = '';
% handles.DyPara.WinType = '';
% handles.DyMask = '';
handles.DyPara.Detrend = 0;
handles.DyALFF.IsALFF = 0;
% handles.DyALFF.LowCut_HighPass = '';
% handles.DyALFF.LowPass_HighCut = '';
handles.DyfALFF.IsfALFF = 0;
% handles.DyfALFF.LowCut_HighPass = '';
% handles.DyfALFF.LowPass_HighCut = '';
handles.DyFC.IsFC = 0;
handles.DyFC.FCROIDef = {''};
handles.DyFC.IsMultiple = 0;
handles.DyDC.IsDC = 0;
% handles.DyDC.rValue = '';
handles.DyReHo.IsReHo = 0;
% handles.DyReHo.Cluster = '';

handles.DyPerAF.IsPerAF = 0;

% handles.DyGSCorr.IsGSCorr = 0;
% handles.DyVMHC.IsVMHC = 0;

% handles.DyConcor.IsConcor = 0;
% handles.DyConcor.IsVoxelWise = 0;
% handles.DyConcor.IsVolumeWise = 0;
% handles.DyConcor.IsSmooth = 0;
% handles.DyConcor.FWHM = '';
% handles.DyConcor.IsALFF = 0;
% handles.DyConcor.IsfALFF = 0;
% handles.DyConcor.IsReHo = 0;
% handles.DyConcor.IsDC = 0;
% handles.DyConcor.IsGSCorr = 0;
% handles.DyConcor.IsVMHC = 0;


function panel_Preprocessing_ButtonDownFcn(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles)
set(handles.panel_Blank,'Visible','on');

function Panel_DyMetrics_ButtonDownFcn(hObject, eventdata, handles)
ReMoveAllPanel(hObject, eventdata, handles)
set(handles.panel_Blank,'Visible','on');

function edit_Parallel_Callback(hObject, eventdata, handles)
num = str2num(get(hObject,'String'));
if num == 0
    delete(gcp('nocreate'));
elseif num > 0
    if isempty(gcp('nocreate'))
        set_matlabpool(num);
    end
end
    

function edit_Parallel_CreateFcn(hObject, eventdata, handles)
set(hObject,'String',0);
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function set_matlabpool(Size_MatlabPool)
    PCTVer = ver('distcomp');
    if ~isempty(PCTVer)
        FullMatlabVersion = sscanf(version,'%d.%d.%d.%d%s');
        if FullMatlabVersion(1)*1000+FullMatlabVersion(2)<8*1000+3 
                    parpool(Size_MatlabPool)
        
        else
                    parpool(Size_MatlabPool)
                
        end  
    end

function psbtn_Save_Callback(hObject, eventdata, handles)
handles = Init_MaskandROI(handles);
guidata(hObject,handles);
PaSet = SaveParamSet(handles);
data = GetData();
[SetSaveName, SetSavePath]= uiputfile({'*.mat'},[PaSet.WorkPath filesep 'TDA_ParamaterAutoSave_' data '.mat']);
if ~isempty(SetSaveName)
    save([SetSavePath SetSaveName],'PaSet');
end



function psbtn_Run_Callback(hObject, eventdata, handles)
handles = Init_MaskandROI(handles);
guidata(hObject,handles);
set(hObject,'enable','off');
set(hObject,'BackgroundColor','Red');   
PaSet = SaveParamSet(handles);
data = GetData();
PaSetSavePath = [PaSet.WorkPath filesep 'TDA_ParamaterAutoSave_' data '.mat'];
save(PaSetSavePath,'PaSet');
call_TDA_batch(PaSet);
set(hObject,'enable','on');
set(hObject,'BackgroundColor',[0.941176470588235,0.941176470588235,0.941176470588235]);
disp('The running of Temporal Dynamics Analysis is done!');

function psbtn_Load_Callback(hObject, eventdata, handles)
[PaSetName,PaSetPath] = uigetfile({'*.mat;'});
if PaSetName ~= 0
    handles = Init_MaskandROI(handles);
    PaSet = SaveParamSet(handles);
    load([PaSetPath filesep PaSetName]);
    handles = LoadParamSet(PaSet,handles);
end

guidata(hObject,handles);

function handles = Init_MaskandROI(handles)
handles.DyMask = getmask(handles);
if ~isempty(handles.Cov.CovOtherROI{1})
    handles.Cov.IsCovOther = 1;
else
    handles.Cov.IsCovOther = 0;
end
if handles.DyFC.IsFC == 1
handles.DyFC.FCROIDef = get(handles.list_FCList,'String');
handles.DyFC.FCROIDef = GetFCROI(handles);
end
% handles.DyGSCorr.Mask = getgscorrmask(handles);

function Mask = getmask(handles)
mainPath = get_Parameters('MainFunctionPath');
if strcmp(handles.DyMask, 'Default')
    Mask = [mainPath filesep 'mask' filesep 'BrainMask_05_61x73x61.img'];
elseif strcmp(handles.DyMask, 'No')
    Mask = '';
elseif ischar(handles.DyMask) == 1
    if exist(handles.DyMask,'file')
       Mask = handles.DyMask;
    else
        disp('Can''t find mask')
        quit force;
    end
end

function Mask = getgscorrmask(handles)
mainPath = get_Parameters('MainFunctionPath');
if strcmp(handles.DyGSCorr.Mask, 'Default')
    Mask = [mainPath filesep 'mask' filesep 'BrainMask_05_61x73x61.img'];
elseif ischar(handles.DyGSCorr.Mask) 
    if exist(handles.DyGSCorr.Mask,'file')
       Mask = handles.DyGSCorr.Mask;
    else
        Mask = '';
        error('Can''t find mask')
    end
end


function data = GetData()
    time = fix(clock);
    year = num2str(time(1));
    month = num2str(time(2),'%02d');
    day = num2str(time(3),'%02d');
    hour = num2str(time(4),'%02d');
    minute= num2str(time(5),'%02d');
    second = num2str(time(6),'%02d');
    data = [year '_' month '_' day '_' hour '_' minute '_' second];
