function call_TDA_batch(PaSet)
%-----------------------------------------------------------
%   Written by SUN Jia-Wei 200413.
%   Mail to Authors: jiaweisun0512@163.com
%
FunImg = PaSet.EPIPath ;
T1Img = PaSet.T1Path;
n = 1;
if PaSet.IsDicom2Nifti == 1 && PaSet.Dicom2Nifti.IsEPI == 1
    Operation{n} = 'EpiDicomtoNifti';
    n = n + 1 ;
end
if PaSet.IsDicom2Nifti == 1 && PaSet.Dicom2Nifti.IsEPI == 1
    Operation{n} = 'T1DicomToNifti';
    n = n + 1 ;
end
if PaSet.IsRemoveFirstnTimePoints == 1
    Operation{n} = 'RemoveFirstTimePoints';
    n = n + 1 ;
end
if PaSet.IsSliceTiming == 1
    Operation{n} = 'SliceTiming';
    n = n + 1 ;
end
if PaSet.IsRealign == 1
    Operation{n} = 'Realign';
    n = n + 1 ;
end

if PaSet.IsNormalize == 1 && strcmpi(PaSet.Normalize.Method, 'EPI')
    Operation{n} = 'NormalizeEpi';
    n = n + 1 ;
end
if PaSet.IsNormalize == 1 && strcmpi(PaSet.Normalize.Method, 'T1New')
    Operation{n} = 'T1CoregisterFun';
    n = n + 1 ;
    Operation{n} = 'NewSegment';
    n = n + 1 ;
    Operation{n} = 'NormalizeNewSeg';
    n = n + 1 ;
end
if PaSet.IsNormalize == 1 && strcmpi(PaSet.Normalize.Method, 'T1Unified')
    Operation{n} = 'T1CoregisterFun';
    n = n + 1 ;
    Operation{n} = 'T1Segment';
    n = n + 1 ;
    Operation{n} = 'NormalizeSeg';
    n = n + 1 ;
end
if PaSet.IsNormalize == 1 && strcmpi(PaSet.Normalize.Method, 'T1Dartel')
    Operation{n} = 'Normalize_newsegment_dartel';
    n = n + 1 ;
end
if  PaSet.IsSmooth == 1
    Operation{n} = 'Smooth';
    
    n = n + 1 ;
end
if PaSet.IsDetrend == 1
    Operation{n} = 'Detrend';
    n = n + 1 ;
end
if PaSet.IsCovariate == 1
    Operation{n} = 'RegressOutCovariates';
    n = n + 1 ;
end
if PaSet.IsFilter == 1
    Operation{n} = 'Filter';
    n = n + 1 ;
end
if PaSet.IsDynamicALFF == 1
    Operation{n} = 'dyALFF';
    n = n + 1 ;
end
if PaSet.IsDynamicfALFF == 1
    Operation{n} = 'dyfALFF';
    n = n + 1 ;
end
if PaSet.IsDynamicPerAF == 1
    Operation{n} = 'dyPerAF';
    n = n + 1 ;
end
if PaSet.IsDynamicFC == 1
    Operation{n} = 'dyFC';
    n = n + 1 ;
end
if PaSet.IsDynamicDC == 1
    Operation{n} = 'dyDC';
    n = n + 1 ;
end
if PaSet.IsDynamicReHo == 1
    Operation{n} = 'dyReHo';
    n = n + 1 ;
end

% if PaSet.IsDynamicGSCorr == 1
%     Operation{n} = 'dyGSCorr';
%     n = n + 1 ;
% end
% if PaSet.IsDynamicVMHC == 1
%     Operation{n} = 'dyVMHC';
%     n = n + 1 ;
% end
% if PaSet.IsDynamicConcor == 1
%     Operation{n} = 'dyConcor';
%     n = n + 1 ;
% end
[FunImg,InputParameter]= GetInputParameter(Operation,PaSet,FunImg,T1Img);
InputParameter.TR = ParaStr2Num(PaSet.TR);
InputParameter.WindowSize = ParaStr2Num(PaSet.DynamicParameter.WinSize);
InputParameter.WindowType =  PaSet.DynamicParameter.WinType;
InputParameter.WindowStep = ParaStr2Num(PaSet.DynamicParameter.WinStep);
InputParameter.Mask = PaSet.DynamicParameter.DyMask;
InputParameter.IsDetrend = PaSet.DynamicParameter.Detrend;
for i = 1 : length(Operation) 
    TDA_kernel(upper(Operation{i}),InputParameter)
end

end



function check_dir(Path)
    if ~exist(Path,'dir')
        return;
    else
        Sun = dir(Path);
        if length(Sun) == 2
            return
        else
            [pathstr,name] = fileparts(Path);
            errordlg([name ' already exists']);
        end
    end
end


function [FunImg,InputParameter] = GetInputParameter(Operation,PaSet,FunImg,T1Img)
for i = 1 : length(Operation)
    switch Operation{i}
        case 'EpiDicomtoNifti'
            InputParameter.EpiDicomToNifti.InDirFunImg = FunImg;
            FunImg = [FunImg 'H'];
            InputParameter.EpiDicomToNifti.OutDirFunImg = FunImg;
        case 'T1DicomToNifti'
             InputParameter.T1DicomToNifti.InDirT1Img = T1Img;
             T1Img = [T1Img 'H'];
             InputParameter.T1DicomToNifti.OutDirT1Img = T1Img;
        case 'RemoveFirstTimePoints'
            InputParameter.RemoveFirstTimePoints.InDirFunImg = FunImg;
            FunImg = [FunImg 'T'];
            InputParameter.RemoveFirstTimePoints.OutDirFunImg = FunImg;
            InputParameter.RemoveFirstTimePoints.TimePointsAmount = ParaStr2Num(PaSet.RemoveFirstnTimePoints.Time);
        case 'SliceTiming'
            InputParameter.SliceTiming.InDirFunImg = FunImg;
            FunImg = [FunImg 'A'];
            InputParameter.SliceTiming.OutDirFunImg = FunImg;
            InputParameter.SliceTiming.SliceNumber = ParaStr2Num(PaSet.SliceTiming.SliceNumber);
            InputParameter.SliceTiming.SliceOrder = ParaStr2Num(PaSet.SliceTiming.SliceOreder);
            InputParameter.SliceTiming.ReferenceSlice = ParaStr2Num(PaSet.SliceTiming.SliceRefer);
            InputParameter.SliceTiming.TR = ParaStr2Num(PaSet.TR);
        case 'Realign'
            InputParameter.Realign.InDirFunImg = FunImg;
            FunImg = [FunImg 'R'];
            InputParameter.Realign.OutDirFunImg = FunImg;
            InputParameter.Realign.RealignParameterDir = [PaSet.WorkPath filesep 'RealignParameter'];
        case 'NormalizeEpi'
            InputParameter.Normalize.EPI.InDirFunImg = FunImg;
            FunImg = [FunImg 'W'];
            InputParameter.Normalize.EPI.OutDirFunImg = FunImg;
            InputParameter.Normalize.EPI.InDirRealignParameter = [PaSet.WorkPath filesep 'RealignParameter'];
            InputParameter.Normalize.EPI.InFodrChekNormPic = [PaSet.WorkPath filesep 'CheckNormalizePicture'];
            InputParameter.Normalize.EPI.BoundingBox = ParaStr2Num(PaSet.Normalize.Bbox);
            InputParameter.Normalize.EPI.VoxSize = ParaStr2Num(PaSet.Normalize.VoxelSize);
        case 'Normalize_newsegment_dartel'
            InputParameter.Normalize.dartel.InDirFunImg = FunImg;
            InputParameter.Normalize.dartel.InDirT1Img = T1Img;
            InputParameter.Normalize.dartel.InDirRealignParameter = [PaSet.WorkPath filesep 'RealignParameter'];
            FunImg = [FunImg 'W'];
            InputParameter.Normalize.dartel.OutDirFunImg = FunImg;
            T1Img = [T1Img 'C'];
            InputParameter.Normalize.dartel.OutDirT1CoregisterFun = T1Img;
            T1Img = [T1Img 'E'];
            InputParameter.Normalize.dartel.OutDirT1NewSegment = T1Img;
            InputParameter.Normalize.dartel.InFodrChekNormPic = [PaSet.WorkPath filesep 'CheckNormalizePicture'];
            InputParameter.Normalize.dartel.BoundingBox = ParaStr2Num(PaSet.Normalize.Bbox);
            InputParameter.Normalize.dartel.VoxSize = ParaStr2Num(PaSet.Normalize.VoxelSize);
            if strcmpi(PaSet.Normalize.People,'Eu')
                InputParameter.Normalize.dartel.AffineRegularisation = 'mni';
            elseif strcmpi(PaSet.Normalize.People,'Ea')
                InputParameter.Normalize.dartel.AffineRegularisation = 'eastern';
            end
        case 'T1CoregisterFun'
            InputParameter.T1CoregisterFun.InDirT1Img = T1Img;
            T1Img = [T1Img 'C'];
            InputParameter.T1CoregisterFun.OutDirT1CoregisterFun = T1Img;
            InputParameter.T1CoregisterFun.InDirRealignParameter = [PaSet.WorkPath filesep 'RealignParameter'];
        case 'T1Segment'
            InputParameter.Segment.InDirT1 = T1Img;
            T1Img = [T1Img 'S'];
            InputParameter.Segment.OutDirT1Segment = T1Img;
            if strcmpi(PaSet.Normalize.People,'Eu')
                InputParameter.AffineRegularisation = 'mni';
            elseif strcmpi(PaSet.Normalize.People,'Ea')
                InputParameter.AffineRegularisation = 'eastern';
            end
        case 'NewSegment'
            InputParameter.NewSegment.InDirT1 = T1Img;
            T1Img = [T1Img 'E'];
            InputParameter.NewSegment.OutDirT1NewSegment = T1Img;
            if strcmpi(PaSet.Normalize.People,'Eu')
                InputParameter.NewSegment.Parameter.AffineRegularisation = 'mni';
            elseif strcmpi(PaSet.Normalize.People,'Ea')
                InputParameter.NewSegment.Parameter.AffineRegularisation = 'eastern';
            end
        case 'NormalizeSeg'
            InputParameter.NormalizeSeg.InDirFunImg = FunImg;
            FunImg = [FunImg 'W'];
            InputParameter.NormalizeSeg.OutDirFunImg = FunImg;
            InputParameter.NormalizeSeg.InDirT1Seg = T1Img;
            InputParameter.NormalizeSeg.InFodrChekNormPic = [PaSet.WorkPath filesep 'CheckNormalizePicture'];
            InputParameter.NormalizeSeg.BoundingBox = ParaStr2Num(PaSet.Normalize.Bbox);
            InputParameter.NormalizeSeg.VoxSize = ParaStr2Num( PaSet.Normalize.VoxelSize);
        case 'NormalizeNewSeg'
             InputParameter.NormalizeNewSeg.InDir_Img = FunImg;
             FunImg = [FunImg 'W'];
             InputParameter.NormalizeNewSeg.OutDir_Img = FunImg;
             InputParameter.NormalizeNewSeg.InDir_NewT1Seg = T1Img;
             InputParameter.NormalizeNewSeg.outfodr_ChekNorm = [PaSet.WorkPath filesep 'CheckNormalizePicture'];
             InputParameter.NormalizeNewSeg.BoundingBox = ParaStr2Num(PaSet.Normalize.Bbox);
             InputParameter.NormalizeNewSeg.VoxSize = ParaStr2Num(PaSet.Normalize.VoxelSize);
        case 'Smooth'
            InputParameter.Smooth.Gaussian.InDirFunImg = FunImg;
            FunImg = [FunImg 'S'];
            InputParameter.Smooth.Gaussian.OutDirFunImg = FunImg;
            InputParameter.Smooth.Gaussian.FWHM = ParaStr2Num(PaSet.Smooth.fwhm);
        case 'Detrend'
            InputParameter.Detrend.InDirFunImg = FunImg;
            FunImg = [FunImg 'D'];
            InputParameter.Detrend.OutDirFunImg = FunImg;
            InputParameter.Detrend.CutNumber = 10;
        case 'Filter'
            InputParameter.Filter.InDirFunImg = FunImg;
            FunImg = [FunImg 'F'];
            InputParameter.Filter.OutDirFunImg = FunImg;
            InputParameter.Filter.InFileMask = 0;
            InputParameter.Filter.SamplePeriod = ParaStr2Num(PaSet.TR);
            InputParameter.Filter.LowPass_HighCutoff = ParaStr2Num(PaSet.Filter.LowPass_HighCut);
            InputParameter.Filter.HighPass_LowCutoff = ParaStr2Num(PaSet.Filter.LowCut_HighPass);
            InputParameter.Filter.IsAddMeanBack = 'Yes';
            InputParameter.Filter.CutNumber = 10;
        case'RegressOutCovariates'
            InputParameter.RegressOutCovariates.InDirFunImg = FunImg;
            InputParameter.RegressOutCovariates.OutDirCov = [FunImg 'Covs'];
            FunImg = [FunImg 'C'];
            InputParameter.RegressOutCovariates.OutDirFunImg = FunImg;
            InputParameter.RegressOutCovariates.IsRemoveIntercept = ~PaSet.Covariate.IsAddMeanBack;
            InputParameter.RegressOutCovariates.PolynomialTrend = PaSet.Covariate.IsCovDetrend ;
            InputParameter.RegressOutCovariates.IsWholeBrain = PaSet.Covariate.IsCovGlobal;
            InputParameter.RegressOutCovariates.IsCSF = PaSet.Covariate.IsCovCSF;
            InputParameter.RegressOutCovariates.IsWhiteMatter = PaSet.Covariate.IsCovWM;
            InputParameter.RegressOutCovariates.IsOtherCovariatesROI = PaSet.Covariate.IsCovOther;
            InputParameter.RegressOutCovariates.IsHeadMotion_Friston24 = PaSet.Covariate.IsCovFriston24; 
            InputParameter.RegressOutCovariates.IsHeadMotion_Rigidbody6 = 0;
            [fdir ,fname] = fileparts(FunImg);
            InputParameter.RegressOutCovariates.InDirRealignParameter = [fdir filesep 'RealignParameter'];
            InputParameter.RegressOutCovariates.OtherCovariatesROIList = PaSet.Covariate.CovOther;
            
        case 'dyALFF'
            InputParameter.DyALFF.InDirFunImg = FunImg;
            [FunPath,FunName] = fileparts(FunImg);
            InputParameter.DyALFF.OutDir= [FunPath filesep 'Results'];
            if ~exist(InputParameter.DyALFF.OutDir,'dir')
                mkdir(InputParameter.DyALFF.OutDir)
            end
            InputParameter.Filter.OutDirFunImg = FunImg;
            InputParameter.DyALFF.LowPass_HighCutoff  = ParaStr2Num(PaSet.DynamicALFF.LowPass_HighCut);
            InputParameter.DyALFF.HighPass_LowCutoff = ParaStr2Num(PaSet.DynamicALFF.LowCut_HighPass);
        case 'dyfALFF'
            InputParameter.DyfALFF.InDirFunImg = FunImg;
            [FunPath,FunName] = fileparts(FunImg);
            InputParameter.DyfALFF.OutDir= [FunPath filesep 'Results'];
            if ~exist(InputParameter.DyfALFF.OutDir,'dir')
                mkdir(InputParameter.DyfALFF.OutDir)
            end
            InputParameter.Filter.OutDirFunImg = FunImg;
            InputParameter.DyfALFF.LowPass_HighCutoff  = ParaStr2Num(PaSet.DynamicfALFF.LowPass_HighCut);
            InputParameter.DyfALFF.HighPass_LowCutoff = ParaStr2Num(PaSet.DynamicfALFF.LowCut_HighPass);
        case 'dyPerAF'
            InputParameter.DyPerAF.InDirFunImg = FunImg;
            [FunPath,FunName] = fileparts(FunImg);
            InputParameter.DyPerAF.OutDir= [FunPath filesep 'Results'];
            if ~exist(InputParameter.DyPerAF.OutDir,'dir')
                mkdir(InputParameter.DyPerAF.OutDir)
            end
        case 'dyFC'
            InputParameter.DyFC.InDirFunImg = FunImg;
            [FunPath,FunName] = fileparts(FunImg);
            InputParameter.DyFC.OutDir= [FunPath filesep 'Results'];
            if ~exist(InputParameter.DyFC.OutDir,'dir')
                mkdir(InputParameter.DyFC.OutDir)
            end
             InputParameter.DyFC.ROIDef = PaSet.DynamicFC.FCROIDef;
             InputParameter.DyFC.IsMultipleLabel = PaSet.DynamicFC.IsMultiple;
        case 'dyReHo'
            InputParameter.DyReHo.InDirFunImg = FunImg;
            [FunPath,FunName] = fileparts(FunImg);
            InputParameter.DyReHo.OutDir= [FunPath filesep 'Results'];
            if ~exist(InputParameter.DyReHo.OutDir,'dir')
                mkdir(InputParameter.DyReHo.OutDir)
            end
             InputParameter.DyReHo.NVoxel = PaSet.DynamicReHo.Cluster;
        case 'dyDC'
            InputParameter.DyDC.InDirFunImg = FunImg;
            [FunPath,FunName] = fileparts(FunImg);
            InputParameter.DyDC.OutDir= [FunPath filesep 'Results'];
            if ~exist(InputParameter.DyDC.OutDir,'dir')
                mkdir(InputParameter.DyDC.OutDir)
            end
             InputParameter.DyDC.rThreshold = ParaStr2Num(PaSet.DynamicDC.rValue);
        case 'dyVMHC'
            InputParameter.DyVMHC.InDirFunImg = FunImg;
            [FunPath,FunName] = fileparts(FunImg);
            InputParameter.DyVMHC.OutDir= [FunPath filesep 'Results'];
            if ~exist(InputParameter.DyVMHC.OutDir,'dir')
                mkdir(InputParameter.DyVMHC.OutDir)
            end
        case'dyGSCorr'
            InputParameter.DyGSCorr.InDirFunImg = FunImg;
            [FunPath,FunName] = fileparts(FunImg);
            InputParameter.DyGSCorr.OutDir = [FunPath filesep 'Results'];
            if ~exist(InputParameter.DyGSCorr.OutDir,'dir')
                mkdir(InputParameter.DyGSCorr.OutDir)
            end
            InputParameter.DyGSCorr.ROIDef{1} = PaSet.DynamicGSCorr.Mask;
        case 'dyConcor'
            InputParameter.DyConcor.InDirFunImg = FunImg;
            [FunPath,FunName] = fileparts(FunImg);
            if PaSet.DynamicConcor.IsALFF == 1;
                InputParameter.ConALFF.InDirFunImg = [FunPath filesep 'Results' filesep 'TemporalDynamics' filesep 'TDA_4D' filesep ...
                    'ALFF_' FunName];
            else
                InputParameter.ConALFF.InDirFunImg = '';
            end
            if PaSet.DynamicConcor.IsfALFF == 1;
                InputParameter.ConfALFF.InDirFunImg = [FunPath filesep 'Results' filesep 'TemporalDynamics' filesep 'TDA_4D' filesep ...
                    'fALFF_' FunName];
            else
                InputParameter.ConfALFF.InDirFunImg = '';
            end
            if PaSet.DynamicConcor.IsReHo == 1;
                InputParameter.ConReHo.InDirFunImg = [FunPath filesep 'Results' filesep 'TemporalDynamics' filesep 'TDA_4D' filesep ...
                    'ReHo_' FunName];
            else
                InputParameter.ConReHo.InDirFunImg = '';
            end
            if PaSet.DynamicConcor.IsDC == 1;
                InputParameter.ConDC.InDirFunImg = [FunPath filesep 'Results' filesep 'TemporalDynamics' filesep 'TDA_4D' filesep ...
                    'DC_' FunName];
            else
                InputParameter.ConDC.InDirFunImg = '';
            end
            if PaSet.DynamicConcor.IsGSCorr == 1;
                InputParameter.ConGSCorr.InDirFunImg = [FunPath filesep 'Results' filesep 'TemporalDynamics' filesep 'TDA_4D' filesep ...
                    'GSCorr_' FunName]; 
            else
                InputParameter.ConGSCorr.InDirFunImg = '';
            end
            if PaSet.DynamicConcor.IsVMHC == 1;
                InputParameter.ConVMHC.InDirFunImg = [FunPath filesep 'Results' filesep 'TemporalDynamics' filesep 'TDA_4D' filesep ...
                    'VMHC_' FunName];    
            else
                InputParameter.ConVMHC.InDirFunImg = '';
            end
            if PaSet.DynamicConcor.IsVoxelWise == 1
                 InputParameter.DyConcor.VoxelWise = [FunPath filesep 'Results'];
            else
                InputParameter.DyConcor.VoxelWise = '';
            end
           if PaSet.DynamicConcor.IsVolumeWise== 1
                 InputParameter.DyConcor.VolumeWise = [FunPath filesep 'Results'];
            else
                InputParameter.DyConcor.VolumeWise = '';
           end
           if PaSet.DynamicConcor.IsSmooth == 1
                InputParameter.DyConcor.FWHM = PaSet.DynamicConcor.fwhm;
           else
               InputParameter.DyConcor.FWHM = '';
           end
                
    end
end


end

function num = ParaStr2Num(str)
if ischar(str)
    num = str2num(str);
elseif isa(str,'double')
    num = str;
else
    error(['formal error']);
end
end