% batch_skullstrip_segment_loctmp;
% batch segmentation using the unified segmentation approach in spm5
% Toolbox for batch processing ASL perfusion based fMRI data.
% All rights reserved.
% Ze Wang @ TRC, CFN, Upenn 2004
%
%segment spm
% apply segm to already normalized images

% Get subject etc parameters
addpath /pkg/spm8 -begin
addpath /big1/zwang/CFN/ADC/batch_create_template/

global defaults;
defaults=spm_get_defaults;
defs = defaults.normalise;

% Turn off template weighting  --> it's turned off by default!
%defs.estimate.weight = '';
%structural images have better resolution. Let's put them to 1x1x1 (instead
%of 2x2x2
%defs.write.vox= [1 1 1];
defs.write.vox= [2 2 2];
% defs.write.bb=[-90 -126 -72
%                 90    90  108];
% defs.write.bb=[-90 -126 -54
%                 90    90  88];   
clear jobs
jobs{1}.spatial{1}.preproc.output.GM = reshape(double([0 0 1]),[1,3]);
jobs{1}.spatial{1}.preproc.output.WM = reshape(double([ 0 0 1 ]),[1,3]);
jobs{1}.spatial{1}.preproc.output.CSF = reshape(double([ 0 0 1 ]),[1,3]);
jobs{1}.spatial{1}.preproc.output.biascor = reshape(double([ 0 ]),[1,1]);
jobs{1}.spatial{1}.preproc.output.cleanup = reshape(double([ 0]),[1,1]);
%            |-tpm 
jobs{1}.spatial{1}.preproc.opts.tpm{1,1} = char([fullfile(PAR.root,PAR.localtemplate, 'Template_6.nii,1')]);
jobs{1}.spatial{1}.preproc.opts.tpm{2,1} = char([fullfile(PAR.root,PAR.localtemplate, 'Template_6.nii,2')]);
jobs{1}.spatial{1}.preproc.opts.tpm{3,1} = char([fullfile(PAR.root,PAR.localtemplate, 'csf.nii')]);
%  note csf.nii was generated by 1-(gm+wm) and masked by the brainedge.nii
%  which was generated by the script: wholebrainmask.m and based on the raw
%  mask: mask=(wm+wm)>0.003
jobs{1}.spatial{1}.preproc.opts.ngaus = reshape(double([ 2 2 2 4 ]),[1,4]);
jobs{1}.spatial{1}.preproc.opts.regtype = char(['mni']);
jobs{1}.spatial{1}.preproc.opts.warpreg = reshape(double([ 1]),[1,1]);
jobs{1}.spatial{1}.preproc.opts.warpco = reshape(double([25]),[1,1]);
jobs{1}.spatial{1}.preproc.opts.biasreg = reshape(double([ 0.0001 ]),[1,1]);
jobs{1}.spatial{1}.preproc.opts.biasfwhm = reshape(double([ 60]),[1,1]);
jobs{1}.spatial{1}.preproc.opts.samp = reshape(double([ 3 ]),[1,1]);
%            \-msk 
jobs{1}.spatial{1}.preproc.opts.msk{1} = char(['']);           
for groupnum=2:length(PAR.groupname)
    par;
for sb =1:length(PAR.subjects) % for each subject 
    sb
    fprintf('Batch normalization for subject %d, %d left....\n',sb,length(PAR.subjects)-sb);
    for nses = 1:PAR.nsess(sb)
       fprintf('session %s ....\n',PAR.sess{nses});

        clear P;
        T1=spm_select('FPList',PAR.structdir{sb,nses},['^' PAR.subjects{sb} '.*' PAR.structprefs '.*\.img$']);
        if strcmp(deblank(T1),'/')||isempty(T1)
            fprintf('No T1 exist for %s session %s!\n',PAR.subjects{sb},PAR.sess{nses});
            continue;
        end
        T1nsk=[spm_str_manip(T1,'rs') '_nsk.nii'];
        if ~exist(T1nsk,'file')
            eval(['!bet ' T1 ' ' spm_str_manip(T1,'rs') '_nsk.nii']);
            eval(['!gunzip ' spm_str_manip(T1,'rs') '_nsk.nii.gz ']);
        end
        % Make the default normalization parameters file name
        
        matname = [spm_str_manip(T1nsk,'sd') '_seg_sn.mat'];
        jobs{1}.spatial{:}.preproc.data={[T1nsk ',1']};
        
     if exist(matname,'file')==0
        fprintf('Segmentation for subject:%s ...\n',PAR.subjects{sb});
        spm_jobman('run',jobs);
     end

    end
end
end