function handles=init_asltbx_pcasl_gui(handles)
%-----------------------------------------------------------
%   Copyright(c) 2015
%	Center for Cognition and Brain Disorders, Hangzhou Normal University, Hangzhou 310015, China
%	Written by JIA Xi-Ze 201507
%	http://www.restfmri.net/
% 	Mail to Authors: jxz.rest@gmail.com, jiaxize@foxmail.com

p=use_p_asltbx_pcasl();

handles.h_UI='';

handles=init_text_or_edit_or_pushbutton(handles,p);
handles=init_text_or_radiobutton(handles,p);
guidata(gcf,handles);
callback_asltbx_pcasl_gui(handles);

end


function handles=init_text_or_edit_or_pushbutton(handles,p)
             UIlist={{'module_name',{'WorkDirectoryText','WorkDirectoryEdit'},...
                      'style','text_edit',...
                      'string',{'Work directory',pwd},...
                      'pos_xy_gap_width',[p.asltbx_pcasl.line1.x,...
                                          p.asltbx_pcasl.line1.y-0.0015,0.002,0.385],...
                     },...
                     {'module_name','WorkDirectoryBtn',...
                      'style','pushbutton',...
                      'string','...',...
                      'tag','work_directory_pushbtn',...
                      'pos_xy_width_height',[p.asltbx_pcasl.line1.x+0.39,...
                                             p.asltbx_pcasl.line1.y-0.001,...
                                             0.05,0.04],...
                     },...
                     {'module_name',{'TRText','TREdit'},...
                      'style','text_edit',...
                      'horizontalalignment','left',...
                      'string',{'TR(sec)','2'},...
                      'pos_xy_gap_width',[p.asltbx_pcasl.line3.x,...
                                          p.asltbx_pcasl.line3.y,0.001,0.15],...
                     },...
                     {'module_name',{'smooth_fwhm_text','smooth_fwhm_edit'},...
                      'style','text_edit',...
                      'string',{'FWHM','[6 6 6]'},... 
                      'horizontalalignment','left',...
                      'pos_xy_gap_width',[p.asltbx_pcasl.line3.x+0.2,...
                                          p.asltbx_pcasl.line3.y,0.02,0.2],...
                     },...
                     {'module_name',{'lable_time_text','lable_time_edit'},...
                      'style','text_edit',...
                      'string',{'Labeling time (sec):','1.48'},... 
                      'horizontalalignment','left',...
                      'pos_xy_gap_width',[p.asltbx_pcasl.line16.x,...
                                          p.asltbx_pcasl.line16.y,0,0.3],...
                     },...
                     {'module_name',{'post_labeling_delay_text','post_labeling_delay_edit'},...
                      'style','text_edit',...
                      'string',{'Post labeling delay time(sec):','1.5'},... 
                      'horizontalalignment','left',...
                      'pos_xy_gap_width',[p.asltbx_pcasl.line16.x+0.4,...
                                          p.asltbx_pcasl.line16.y,0,0.4],...
                     },...
                     {'module_name',{'slice_acquisition_time_text','slice_acquisition_time_edit'},...
                      'style','text_edit',...
                      'string',{'Slice time(msec, 0 for 3D):','33.5'},... 
                      'horizontalalignment','left',...
                      'pos_xy_gap_width',[p.asltbx_pcasl.line17.x,...
                                          p.asltbx_pcasl.line17.y-0.014,0,0.3],...
                     },...
                     {'module_name',{'TE_for_M0_acquisition_text','TE_for_M0_acquisition_edit'},...
                      'style','text_edit',...
                      'string',{'TE for the M0 acqusition (msec):','11'},... 
                      'horizontalalignment','left',...
                      'pos_xy_gap_width',[p.asltbx_pcasl.line17.x+0.4,...
                                          p.asltbx_pcasl.line17.y-0.014,0,0.4],...
                     },...
                     {'module_name',{'labele_efficiency_text','labele_efficiency_edit'},...
                      'style','text_edit',...
                      'string',{'Labeling efficiency:','0.85'},... 
                      'horizontalalignment','left',...
                      'pos_xy_gap_width',[p.asltbx_pcasl.line18.x,...
                                          p.asltbx_pcasl.line18.y-0.014*2,0,0.3],...
                     },...
                     {'module_name',{'M0_value_text','M0_value_edit'},...
                      'style','text_edit',...
                      'string',{'M0 value:',''},... 
                      'horizontalalignment','left',...
                      'enable','off',...
                      'visible','off',...
                      'pos_xy_gap_width',[p.asltbx_pcasl.line23.x,...
                                          p.asltbx_pcasl.line23.y-0.014,0,0.15],...
                     },...
                     {'module_name',{'M0_image_select_text','M0_image_select_edit'},...
                      'style','text_edit',...
                      'string',{'M0 image:',pwd},...
                      'horizontalalignment','left',...
                      'enable','off',...
                      'visible','off',...
                      'pos_xy_gap_width',[p.asltbx_pcasl.line23.x+0.18,...
                                          p.asltbx_pcasl.line23.y-0.014,0.002,0.4],...
                     },...
                     {'module_name','M0_image_select_pushbtn',...
                      'style','pushbutton',...
                      'string','...',...
                      'horizontalalignment','left',...
                      'tag','M0_image_select_pushbtn',...
                      'enable','off',...
                      'visible','off',...
                      'pos_xy_width_height',[p.asltbx_pcasl.line23.x+0.18+0.41,...
                                             p.asltbx_pcasl.line23.y-0.014-0.001,...
                                             0.05,0.04],...
                     },...
                     {'module_name',{'ROI_mask_4_M0_text','ROI_mask_4_M0_edit'},...
                      'style','text_edit',...
                      'string',{'ROI mask for calculating M0:',pwd},...
                      'horizontalalignment','left',...
                      'enable','off',...
                      'visible','off',...
                      'pos_xy_gap_width',[p.asltbx_pcasl.line24.x+0.18,...
                                          p.asltbx_pcasl.line24.y-0.014*2,0.002,0.4],...
                     },...
                     {'module_name','ROI_mask_4_M0_pushbtn',...
                      'style','pushbutton',...
                      'string','...',...
                      'horizontalalignment','left',...
                      'tag','ROI_mask_4_M0_pushbtn',...
                      'enable','off',...
                      'visible','off',...
                      'pos_xy_width_height',[p.asltbx_pcasl.line24.x+0.18+0.41,...
                                             p.asltbx_pcasl.line24.y-0.014*2,...
                                             0.05,0.04],...
                     },...
                     {'module_name','run_asltbx_pcasl_pushbtn',...
                      'style','pushbutton',...
                      'string','RUN',...
                      'tag','tag_run_asltbx_pcasl_pushbtn',...
                      'pos_xy_width_height',[p.asltbx_pcasl.line25.x+0.665,...
                                             p.asltbx_pcasl.line25.y-0.001,...
                                             0.14,0.08],...
                     }
                     };
                                 
if_assign_style='';                 
handles.h_UI=draw_asltbx_UI(UIlist,handles.h_UI,handles.MainFigure,if_assign_style); 
end



function handles=init_text_or_radiobutton(handles,p)
rbtn_gap1=0.01;
rbtn_gap2=0.03;
UIlist={{'module_name','asl_tbx_tyle',...
         'module_para',{'text','pasl_type','casl_type'},...              
          'style','text_radiobutton_horiz_line',...
          'string',{'ASL type:','pasl','casl or p-casl'},...
          'tag',{'defaulttag','open_pasl_tbx','open_casl_tbx'},...
          'value',{0,0,1},...
          'pos_x_y_gap1_gap2',[p.asltbx_pcasl.line1.x+0.5,...
                               p.asltbx_pcasl.line1.y-0.0015,0.01,0.005],...
                     },...
        {'module_name','select_image_format_text',...
         'module_para',{'text','analyze_radiotn','nifti_radiotn'},...              
          'style','text_radiobutton_horiz_line',...
          'string',{'Output image file format:','NIFTI','Analyze'},...
          'value',{0,1,0},...
          'visible','off',...
          'pos_x_y_gap1_gap2',[p.asltbx_pcasl.line5.x,...
                               p.asltbx_pcasl.line5.y-0.0015,rbtn_gap1,rbtn_gap2],...
                     },...
        {'module_name','save_4d_image_series',...
         'module_para',{'text','yes','no'},...
          'style','text_radiobutton_horiz_line',...
          'string',{'Output image time series format:','4D','3D'},...
          'value',{0,1,0},...
          'pos_x_y_gap1_gap2',[p.asltbx_pcasl.line6.x,...
                               p.asltbx_pcasl.line6.y-0.0015,rbtn_gap1,rbtn_gap2],...
                     },...
         {'module_name','magnetic_field',...
         'module_para',{'text','mf_1_5T','mf_3_T','mf_4_T'},...
          'style','text_radiobutton_horiz_line',...
          'string',{'Magnetic field:','1.5T','3T','4T'},...
          'value',{0,0,1,0},...
          'pos_x_y_gap1_gap2',[p.asltbx_pcasl.line7.x,...
                               p.asltbx_pcasl.line7.y-0.0015,rbtn_gap1,rbtn_gap2],...
                     },...    
         {'module_name','first_image_type',...
         'module_para',{'text','lable','control'},...
          'style','text_radiobutton_horiz_line',...
          'string',{'Acquisition order:','Labeling first','Control first'},...
          'value',{0,1,0},...
          'pos_x_y_gap1_gap2',[p.asltbx_pcasl.line8.x,...
                               p.asltbx_pcasl.line8.y-0.0015,rbtn_gap1,rbtn_gap2],...
                     },...
          {'module_name','subtraction_method',...
         'module_para',{'text','simple','surround','sinc'},...
          'style','text_radiobutton_horiz_line',...
          'string',{'Subtraction method:',...
                     'Simple','Surround',' Sinc'},...
          'value',{0,1,0,0},...
          'pos_x_y_gap1_gap2',[p.asltbx_pcasl.line9.x,...
                               p.asltbx_pcasl.line9.y-0.0015,rbtn_gap1,rbtn_gap2],...
                     },...  
          {'module_name','subtraction_order',...
         'module_para',{'text','control_lable','lable_control'},...
          'style','text_radiobutton_horiz_line',...
          'string',{'Subtraction order:','Control-lable','Lable-control '},...
          'value',{0,1,0},...
          'pos_x_y_gap1_gap2',[p.asltbx_pcasl.line10.x,...
                               p.asltbx_pcasl.line10.y-0.0015,rbtn_gap1,rbtn_gap2],...
                     },...  
          {'module_name','apply_the_mask',...
         'module_para',{'text','use_mask','not_use_mask'},...
          'style','text_radiobutton_horiz_line',...
          'string',{'Remove background voxels?','Yes','No'},...
          'value',{0,1,0},...
          'pos_x_y_gap1_gap2',[p.asltbx_pcasl.line11.x,...
                               p.asltbx_pcasl.line11.y-0.0015,rbtn_gap1,rbtn_gap2],...
                     },...  
          {'module_name','quantitative_cbf',...
         'module_para',{'text','yes_quantitative','no_quantitative'},...
          'style','text_radiobutton_horiz_line',...
          'string',{'Need quantitative CBF?','Yes','No'},...
          'value',{0,1,0},...
          'visible','off',...
          'pos_x_y_gap1_gap2',[p.asltbx_pcasl.line12.x,...
                               p.asltbx_pcasl.line12.y-0.0015,rbtn_gap1,rbtn_gap2],...
                     },...                    
          {'module_name','output_pseudo_BOLD',...
         'module_para',{'text','yes_pseudo','no_pseudo'},...
          'style','text_radiobutton_horiz_line',...
          'string',{'Save pseudo BOLD images?','Yes','No'},...
          'value',{0,1,0},...
          'visible','off',...
          'pos_x_y_gap1_gap2',[p.asltbx_pcasl.line13.x,...
                               p.asltbx_pcasl.line13.y-0.0015,rbtn_gap1,rbtn_gap2],...
                     },...
          {'module_name','save_delta_M',...
         'module_para',{'text','yes_save_delta','no_save_delta'},...
          'style','text_radiobutton_horiz_line',...
          'string',{'Save the perfusion weighted images?','Yes','No'},...
          'value',{0,0,1},...
          'pos_x_y_gap1_gap2',[p.asltbx_pcasl.line12.x,...
                               p.asltbx_pcasl.line12.y-0.0015,rbtn_gap1,rbtn_gap2],...
                     },...  
         {'module_name','additional_M0',...
         'module_para',{'text','yes_M0','no_M0'},...
          'style','text_radiobutton_horiz_line',...
          'string',{'Have additional M0?','Yes','No'},...
          'value',{0,0,1},...
          'pos_x_y_gap1_gap2',[p.asltbx_pcasl.line13.x,...
                               p.asltbx_pcasl.line13.y-0.0015,rbtn_gap1,rbtn_gap2],...
                     },...              
         {'module_name','use_a_unique_m0',...
         'module_para',{'text','yes_use_unique_m0','no_use_unique_m0'},...
          'style','text_radiobutton_horiz_line',...
          'string',{'Use a unique M0 for calibration?','Yes','No'},...
          'tag',{'defaulttag','yes_use_unique_m0','no_use_unique_m0'},...
          'value',{0,0,0},...
          'visible','off',...
          'pos_x_y_gap1_gap2',[p.asltbx_pcasl.line20.x,...
                               p.asltbx_pcasl.line20.y,rbtn_gap1,rbtn_gap2],...
                     },...
         {'module_name','which_approximate_m0',...
         'module_para',{'text','M0wm','M0csf'},...
          'style','text_radiobutton_horiz_line',...
          'string',{'Which approximate M0?','M0wm','M0csf'},...
          'tag',{'defaulttag','use_M0wm','use_M0csf'},...
          'value',{0,0,0},...
          'enable','off',...
          'visible','off',...
          'pos_x_y_gap1_gap2',[p.asltbx_pcasl.line21.x,...
                               p.asltbx_pcasl.line21.y,rbtn_gap1,rbtn_gap2],...
                     },...
           {'module_name','know_unique_m0',...
         'module_para',{'text','yes','no'},...
          'style','text_radiobutton_horiz_line',...
          'string',{'Do you know the unique M0 value?','Yes','No'},...
          'tag',{'defaulttag','yes_know_unique_m0_vaule','not_know_unique_m0_value'},...
          'value',{0,0,0},...
          'enable','off',...
          'visible','off',...
          'pos_x_y_gap1_gap2',[p.asltbx_pcasl.line22.x,...
                               p.asltbx_pcasl.line22.y,rbtn_gap1,rbtn_gap2],...
                     }          
                     };
                 
                 
%           {'module_name','',...
%          'module_para',{'text','',''},...
%           'style','text_radiobutton_horiz_line',...
%           'string',{':','',''},...
%           'value',{0,},...
%           'pos_x_y_gap1_gap2',[p.asltbx_pcasl.line11.x,...
%                                p.asltbx_pcasl.line11.y-0.0015,0.01,0.01],...
%                      }                    
if_assign_style='';                 
handles.h_UI=draw_asltbx_UI(UIlist,handles.h_UI,handles.MainFigure,if_assign_style); 
                 
end