function infodr_tp_cut(niifilepath,outdir,Parameter,Prefix)
%-----------------------------------------------------------
%   Copyright(c) 2021
%	Written by Li Zi-qi 210623
%	http://www.restfmri.net/


[DataAllVolume, ~, Header]=rp_readfile(niifilepath);
Data_nv=size(DataAllVolume,4);
[~,filename,ext]=fileparts(niifilepath);
switch upper(Parameter.type)
    case 'CUTNUMBER'
        CutNumber=str2num(Parameter.Data);
        endVolume=Data_nv-CutNumber;
    case 'REFERENCE'
        Ref_datapath=Parameter.Data;
        [RefData, ~, ~]=rp_readfile(Ref_datapath);
        Ref_nv=size(RefData,4);
        endVolume=Ref_nv;
end
if endVolume>size(DataAllVolume,4)
    error('endVolume must be small than DataVolume!');
end
if ~exist(outdir,'dir')
    mkdir(outdir);
end
CutNumber=Data_nv-endVolume;
imageOUT=[outdir filesep Prefix num2str(CutNumber) '_' filename ext];
AllVolume=DataAllVolume(:,:,:,1:endVolume);
rp_Write4DNIfTI(AllVolume,Header,imageOUT);
end