function [handles,UserP]=InitGUI_AllVersions(handles)
% initialization pipeline
%------------------------------------------------------------------------------------------------------------------------------
% Input:
%     handles  -  handles of all GUI
% Output:
%     handles  -  handles of all GUI
%     UserP    -  the struct of GUI position
%-----------------------------------------------------------
%   Copyright(c) 2015
%	Center for Cognition and Brain Disorders, Hangzhou Normal University, Hangzhou 310015, China
%	Written by JIA Xi-Ze 20141201
%	http://www.restfmri.net/
% 	Mail to Authors: jxz.rest@gmail.com, jiaxize@foxmail.com


set(handles.MainFigure,'color',[240/250,240/250,240/250]);
UserP=Init_GUIUserP();
handles=InitGUI_VersionRadioBtn(handles,UserP);
handles=InitGUI_MaskParaGUI(handles,UserP);


end






function handles=InitGUI_VersionRadioBtn(handles,UserP)
IfVisible='on';    
handles.UIhandles.BasicVersionRadioBtn.handle=...
                    uicontrol(handles.MainFigure,....
                             'style','radiobutton',...
                             'unit','normalized',...
                             'visible',IfVisible,...
                             'string','pipeline',...
                             'fontname','fixedwidth',...
                             'fontweight','bold',...
                             'fontunits','normalized',...
                             'fontsize',0.45,...
                             'tag',get_GuiTag('BasicVersionRadioBtn'),...
                             'position',[UserP.VersionBtn.X,UserP.VersionBtn.Y,0.1,0.04]);

handles.UIhandles.AdvancedVersionRadioBtn.handle=....
                    uicontrol(handles.MainFigure,....
                             'style','radiobutton',...
                             'unit','normalized',...
                             'visible',IfVisible,...
                             'string','flexible',...
                             'fontname','fixedwidth',...
                             'fontweight','bold',...
                             'fontunits','normalized',...
                             'fontsize',0.45,...
                             'value',1,...
                             'tag',get_GuiTag('AdvancedVersionRadioBtn'),...
                             'position',[UserP.VersionBtn.X+0.1,UserP.VersionBtn.Y,0.13,0.04]);
end




function handles=InitGUI_MaskParaGUI(handles,UserP)
 IfVisible='off';    
 handles.hPara.UserMask.Text=uicontrol(handles.MainFigure,'style','text',...
                             'unit','normalized',...
                             'visible',IfVisible,...
                             'string','User Defined Mask',...
                             'fontname','fixedwidth',...
                             'fontweight','bold',...
                             'fontunits','normalized',...
                             'fontsize',0.5,...
                             'backgroundcolor',get(gcf,'color'),...
                             'position',[UserP.Parameter.Line1.X,...
                                         UserP.Parameter.Line1.Y-0.005,...
                                         0.2,0.04]);                         
handles.hPara.UserMask.Edit=uicontrol(handles.MainFigure,'style','edit',...
                             'unit','normalized',...
                             'visible',IfVisible,...
                             'BackgroundColor',[1 1 1],...
                             'position',[UserP.Parameter.Line1.X+0.19,...
                                         UserP.Parameter.Line1.Y...
                                         ,0.2,0.04]);  
handles.hPara.UserMask.Btn=uicontrol(handles.MainFigure,'style','pushbutton',...
                             'unit','normalized',...
                             'visible',IfVisible,...
                             'string','...',...
                             'position',[UserP.Parameter.Line1.X+0.4,...
                                         UserP.Parameter.Line1.Y,...
                                         0.05,0.04]);     
set(handles.hPara.UserMask.Btn,'callback',{@UserMaskBtn_Callback,handles});
 
 
 
end


function UserMaskBtn_Callback(hObject, eventdata,handles)  
    [filename, pathname] = uigetfile({'*.nii;*.img','Img Files (*.nii,*.img)'},'Please select a mask file');
    if 0~=filename
        set(handles.hPara.UserMask.Edit,'string',[pathname filename]); 
    end
    
end


