function call_pipeline_batch(ProcessQueue,InputParameter,handles)

  h_basic_radiobtn=handles.UIhandles.BasicVersionRadioBtn.handle;

  h_run_btn=handles.UIhandles.RunBtn.handle; 
  analysis_dir=get(handles.UIhandles.WorkDirectoryEdit.handle,'string');
  report_path=[analysis_dir filesep 'error_' restgui_misc('get_auto_time') '.txt'];
  
  raw_property=pushbtn_locking('lock',h_run_btn);           
try
   if 1==get(h_basic_radiobtn,'value') 
      display_help_msgbox(); 
   end
   pipeline_batch(ProcessQueue,InputParameter);
catch ME
   save_error_report(ME,report_path);
   pushbtn_locking('unlock',h_run_btn,raw_property);
   rethrow(ME);
end

pushbtn_locking('unlock',h_run_btn,raw_property);


end


function display_help_msgbox()
uiwait(msgbox({'E.g. "FunRawHTARW" means you start with images which have been converted DICOM to NIFTI,removed first N time points, slice timing corrected, realigned and normalized.';...
        '';...
        'Abbreviations:';...
        'H - DICOM to NIFTI'
        'T - Remove First N Time Points';...
        'A - Slice Timing;';...
        'R - Realign';...
        'W - Normalize';...
        'S - Smooth';...
        'D - Detrend';...
        'F - Filter';...
        'C - Covariates Removed';...
        'C - T1 Coregister';...
        'S - T1 Segment';...
        'E - New Segment';...
        'm - Dividing Mean Within Mask';...
        'z - Calculating Z-Score Within Mask';...
        },'Tips for Starting Directory Name'));
end