function get_citation(tag)
%-----------------------------------------------------------
%   Copyright(c) 2015
%	Written by Sun Jia-Wei 200813
%	http://www.restfmri.net/


switch lower(tag)
    case 'restplus'
        fprintf('Citing Information:\n');
        fprintf('If you think RESTplus is useful for your work, citing it in your paper would be greatly appreciated!\n');
        fprintf('Reference: Jia X-Z, Wang J, Sun H-Y, et al. RESTplus: an improved toolkit for resting-state functional magnetic resonance imaging data processing. Science Bulletin. 2019;64(14):953-954. doi:10.1016/j.scib.2019.05.008\n');
    case 'peraf'
        fprintf('\nCiting Information:\n')
        fprintf('If you will use PerAF as result,  citing it in your paper would be greatly appreciated\n');
        fprintf('References:Jia X-Z, Sun J-W, Ji G-J, et al. Percent amplitude of fluctuation: A simple measure for resting-state fMRI signal at single voxel level. Pham D, ed. PLoS ONE. 2020;15(1):e0227021. doi:10.1371/journal.pone.0227021\n');
    case 'pca'
        fprintf('\nCiting Information:\n')
        fprintf('If you will use SSM-PCA,  citing it in your paper would be greatly appreciated\n');
        fprintf('References: Yuan L-X, Wang J-B, Zhao N, et al. Intra- and Inter-scanner Reliability of Scaled Subprofile Model of Principal Component Analysis on ALFF in Resting-State fMRI Under Eyes Open and Closed Conditions. Front Neurosci. 2018;12:311. doi:10.3389/fnins.2018.00311\n');
    otherwise
        fprintf([tag ', the citation for this have not been there yet.']);
end
    
end