function indir_NormalizeNewSeg(InDir_Img,OutDir_Img,InDir_NewT1Seg,outfodr_ChekNorm,Parameter)
%Parameter.BoundingBox
%Parameter.VoxSize
%outfodr_ChekNorm = ''; do not creat folder for check normalize
%Normalize InDir_Img by new segment
%-----------------------------------------------------------
%   Copyright(c) 2015
%	Center for Cognition and Brain Disorders, Hangzhou Normal University, Hangzhou 310015, China
%	Written by JIA Xi-Ze 20161108
%	http://www.restfmri.net/
% 	Mail to Authors: jxz.rest@gmail.com, jiaxize@foxmail.com


rp_spm_ver_check('NormalizeNewSeg');
[ImgType,ImgExt]=indir_Chek(InDir_Img);
SubfodrList=dir_NameList(InDir_Img);
SpmBatch=cell(length(SubfodrList),1);

for i=1:length(SubfodrList)
    SpmBatch{i}.jobs = init_SpmBatch('Normalizewrite_spm12');
    Parameter=init_NormalizeNewSegParameter(InDir_Img,InDir_NewT1Seg,SubfodrList{i},ImgType,Parameter);
    SpmBatch{i} = output_SpmBatch4NormalizeNewSeg(SpmBatch{i},Parameter);
end


batch_run_spm_jobman(SubfodrList,SpmBatch);


if ~strcmpi(InDir_Img,OutDir_Img)
    move_InDir2OutDir(InDir_Img,OutDir_Img,'RegularExpression',[get_Postfix('Normalize_NewSeg') '*']);
end

if ~isempty(outfodr_ChekNorm)
   indir_GeneratePics4Chek(OutDir_Img,outfodr_ChekNorm);
end


function Parameter=init_NormalizeNewSegParameter(InDir_FunImg,InDir_NewT1Seg,SubfodrNam,ImgType,Parameter)
Parameter.FileList=spread_Fodr4SPM([InDir_FunImg filesep SubfodrNam],ImgType);
Parameter.DefFilePath={inpath_Misc([InDir_NewT1Seg filesep SubfodrNam filesep 'y_*.nii'],'Get1SubPath_RegExp')};


function SpmBatch = output_SpmBatch4NormalizeNewSeg(SpmBatch,Parameter)
SpmBatch.jobs{1,1}.spatial{1,1}.normalise{1,1}.write.subj.def = Parameter.DefFilePath;
SpmBatch.jobs{1,1}.spatial{1,1}.normalise{1,1}.write.subj.resample = Parameter.FileList; 
if isfield(Parameter,'BoundingBox')
    SpmBatch.jobs{1,1}.spatial{1,1}.normalise{1,1}.write.woptions.bb = Parameter.BoundingBox;
end

if isfield(Parameter,'VoxSize')
    SpmBatch.jobs{1,1}.spatial{1,1}.normalise{1,1}.write.woptions.vox = Parameter.VoxSize;
end