function img_handle = rp_sliceviewer_set(init_show_set)    

if nargin<1
    init_show_set = 'TRANSVERSEVIEW_4X5';
end
switch upper(init_show_set)
    case 'TRANSVERSEVIEW_6X5'
        inputcfg = view_6x5_cfg();
        img_handle = rp_sliceviewer('showunderlay',inputcfg.underly_cfg.underlay_file);
        rp_sliceviewer('transverseview',img_handle);
    case 'TRANSVERSEVIEW_4X5'
        inputcfg = view_4x5_cfg();
        img_handle = rp_sliceviewer('showunderlay',inputcfg.underly_cfg.underlay_file);
        rp_sliceviewer('transverseview',img_handle);
%     case 'SAGITTALVIEW_4X5'
%         inputcfg = view_4x5_cfg();
%         img_handle = rp_sliceviewer('showunderlay',inputcfg.underly_cfg.underlay_file);
%         rp_sliceviewer('sagittalview',img_handle);
end
rp_sliceviewer('set_magnify',img_handle,inputcfg.magnify_cfg.value);
rp_sliceviewer('setcrosshair',img_handle,inputcfg.crosshair_cfg.ifvisible); 
rp_sliceviewer('set_montage',img_handle,inputcfg.motage_cfg.cross,...
                                         inputcfg.motage_cfg.down,...
                                         inputcfg.motage_cfg.space,...
                                         inputcfg.motage_cfg.iflable); 
rp_sliceviewer('set_xyz_coordinate',img_handle,...
                                        inputcfg.xyz_coordinate_cfg.x,...
                                        inputcfg.xyz_coordinate_cfg.y,...
                                        inputcfg.xyz_coordinate_cfg.z);
end

function inputcfg = view_6x5_cfg()
    rp_pth = which('restplus.m');
    rp_dr = fileparts(rp_pth);
    underlay_file = [rp_dr filesep 'Template' filesep 'ch2.nii'];
    inputcfg.underly_cfg.underlay_file = underlay_file;
    inputcfg.magnify_cfg.value = 1; % x0.5
    inputcfg.motage_cfg.cross = 5;
    inputcfg.motage_cfg.down = 6;
    inputcfg.motage_cfg.space = 5;
    inputcfg.motage_cfg.iflable = 1;
    inputcfg.xyz_coordinate_cfg.x = 0;
    inputcfg.xyz_coordinate_cfg.y = 0;
    inputcfg.xyz_coordinate_cfg.z = 10;
    inputcfg.crosshair_cfg.ifvisible = 'off';
end

function inputcfg = view_4x5_cfg()
    rp_pth = which('restplus.m');
    rp_dr = fileparts(rp_pth);
    underlay_file = [rp_dr filesep 'Template' filesep 'ch2.nii'];
    inputcfg.underly_cfg.underlay_file = underlay_file;
    inputcfg.magnify_cfg.value = 1; % x0.5
    inputcfg.motage_cfg.cross = 5;
    inputcfg.motage_cfg.down = 4;
    inputcfg.motage_cfg.space = 5;
    inputcfg.motage_cfg.iflable = 1;
    inputcfg.xyz_coordinate_cfg.x = 0;
    inputcfg.xyz_coordinate_cfg.y = 0;
    inputcfg.xyz_coordinate_cfg.z = 10;
    inputcfg.crosshair_cfg.ifvisible = 'off';
end